/**
 * La classe Person definisce i dati necessari per ciascun contatto della AddrBook (rubrica).
 */

public class Person implements Comparable {
    private String cognome = "";
    private String nome = "";
    private String telefono = "";
    private String indirizzo = "";

    /**
	 * Il costruttore riempie le variabili dell'oggetto.
	 */
    public Person(String cogn, String nom, String tel, String ind) {
        cognome = cogn;
        nome = nom;
        telefono = tel;
        indirizzo = ind;
    }
	
	/**
	 * Confronta l'oggetto con uno passatogli
	 * @param ob un oggetto di tipo Object
     * @return true se il cognome ed il nome coincidono con quelli del parametro
	 */
    public boolean equals(Object ob) {
		Person v = (Person) ob;
        boolean res = (cognome.equalsIgnoreCase (v.cognome)) && (nome.equalsIgnoreCase(v.nome));
        return res;
    }
	
	/**
	 * Confronta cognome e nome con quelli di ob 
	 * @param ob un oggetto di tipo Person
	 * @return intero: 0 se coincidono; 
	 * >0 se cognome+nome e' maggiore di cognome+nome di ob;
     * <0 se congome+nome e' minore di cognome+nome di ob
	 */
    public int compareTo(Object ob) throws ClassCastException {
        if (!(ob instanceof Person )) throw new ClassCastException ();
        else {
            Person v = (Person) ob;
            String cn1 = this.cognome + " " +this.nome ;
            int res = cn1.compareToIgnoreCase (v.cognome + " " +v.nome );
            return res;
        }
    }
	
	/**
	 * @return Cognome
	 */
    public String getCognome() {
        return cognome;
    }
	
	/**
	 * @return Nome
	 */	
    public String getNome() {
        return nome;
    }

	/**
	 * @return Indirizzo
	 */	
    public String getIndirizzo() {
        return indirizzo;
    }
	
	/**
	 * @return Telefono
	 */	
    public String getTelefono() {
        return telefono;
    }
}
