/**
 * Esempio di uso del design pattern Observer
 *
 * La classe ConcreteObserver e' Store
 * La classe ConcreteSubject e' AddrBook
 * La classe Dialog e' usata per interagire con l'utente ed inizializzare oggetti
 */

import java.io.*;

public class Dialog {
    public static void main(String args[]){
        Store st = new Store(); 
        AddrBook book = AddrBook.getInstance(); 

        book.addObserver(st);  // indica che st e' un observer di book
        
        book.insert("Shearer","Alan","111220022","Windsor Terrace");
		book.insert("Hague","William","340343434","Oxford Street");
		book.insert("Walker","Johnny","340000","Eiden Castle");
		book.insert("Smith","Tim","234453445","Lucky Street");
		book.insert("Nakata","Hide","345665544","Taito-ku, Tokyo");
		book.insert("Baudo","Pippo","095566554","Militello Val di Catania");
	
        try{
            BufferedReader in=new BufferedReader(new InputStreamReader(System.in));
            System.out.println(": : : : RUBRICA : : : :");
            int x;
            while(true){
                System.out.println("Opzioni");
                System.out.println("1-Inserimento");
                System.out.println("2-Ricerca");  
                System.out.println("3-Fine");
                String s = in.readLine(); 
                x = Integer.parseInt(s);
                if (x == 1) {
                    System.out.print("Nome: ");
                    String nome = in.readLine(); 
                    System.out.print("Cognome: "); 
                    String cognome = in.readLine(); 
                    System.out.print("Indirizzo: "); 
                    String ind = in.readLine(); 
                    System.out.print("Telefono: "); 
                    String tel = in.readLine(); 
                    book.insert(cognome,nome,tel,ind);
                }
                else if (x == 2) {
                    System.out.print("Nome: "); 
                    String nome = in.readLine(); 
                    System.out.print("Cognome: "); 
                    String cognome = in.readLine(); 
                    Person nom2 = book.find(cognome,nome);
                    System.out.println("* Telefono: "+nom2.getTelefono()+" *");
                    System.out.println("* Indirizzo: "+nom2.getIndirizzo()+" *");
                }
                else break;
            } //while
        } catch(Exception e) { }
    }
}
