/**
 * La classe AddrBook, che implementa la rubrica telefonica tramite un Vector di oggetti Person,
 * e' un ConcreteSubject, pertanto invoca notifyObservers() quando il suo contenuto cambia
 */

import java.util.*;

public class AddrBook extends Observable {
    public static AddrBook myself = new AddrBook();
    private Vector col; 
    private AddrBook(){
        col = new Vector();
    }
	/**
	 * E' un Singleton, voglio avere una sola istanza di AddrBook
	 */
	public static AddrBook getInstance() {
		return myself; 
	}
    public int size() { 
        return col.size(); 
    }
    public void clear() { 
        col.clear(); 
        setChanged();
        notifyObservers(getValue());
    }
    public boolean isEmpty() { 
        return col.isEmpty();
    }
    public boolean insert(String cognome, String nome, String telefono, String indirizzo) {
        Person nom1 = new Person(cognome, nome, telefono, indirizzo);
        Person nom2 = find(cognome, nome);
        if (nom2 != null) return false; 
        if (col.isEmpty()) {
            col.addElement(nom1);
            setChanged();
            notifyObservers(getValue()); 
            return true;
        }
        Iterator iter = col.iterator();
        // trova posizione per l'inserimento
        while (iter.hasNext() && nom1.compareTo(nom2 = (Person)iter.next()) > 0) { 
        } 
        if (nom2.equals(nom1)) return false;
        if (nom1.compareTo(nom2) < 0) {
            int pos = col.indexOf(nom2);
            col.insertElementAt(nom1, pos);
        }
        else col.addElement(nom1);
        setChanged();
        notifyObservers(getValue()); 
        return true;
    }
    public boolean modifica(String cognome, String nome, String telefono, String indirizzo) {
        Person nom1 = new Person(cognome,nome,telefono,indirizzo);
        Person nom2 = null;
        int dim = col.size();
        if (col.isEmpty()) return false;
        Iterator iter = col.iterator();
        while (iter.hasNext() && nom1.compareTo(nom2 = (Person)iter.next()) > 0) {
        }
        if ((nom2.equals(nom1))) {	
            int pos = col.indexOf(nom2);
            col.setElementAt(nom1, pos);
            setChanged();
            notifyObservers(getValue()); 
            return true;
        }
        return false;
    }	
    public boolean delete(String cognome, String nome ) {
        Person nom1 = new Person(cognome, nome, "", "");
        Person nom2 = null;
        Iterator iter = col.iterator();
        while (iter.hasNext() && nom1.compareTo(nom2 = (Person)iter.next()) > 0) {
        }
        if (nom2!= null && nom1.equals(nom2)) {
            col.remove(nom2);
            setChanged();
            notifyObservers(getValue()); 
            return true;
        }
        return false;
    }
    public Person find(String cognome, String nome ) {
        Person nom1 = new Person(cognome, nome, "", "");
        Person nom2 = null;			
        Iterator iter = col.iterator(); 
        while (iter.hasNext() && nom1.compareTo(nom2 = (Person)iter.next()) > 0) {
        }
        if (nom2 != null && nom1.equals(nom2)) return nom2;
        return null;
    }
    // trasforma il vettore di oggetti Person in vettore di stringhe
    public Vector getValue() {
        Vector nom1 = new Vector();
        String s = null;
        int size = col.size();
        for (int i=0; i<size; i++) { 
            Person nom = (Person) col.elementAt(i);
            s = completeString(nom.getCognome(),40) + completeString(nom.getNome(),40)
               +completeString(nom.getTelefono(),40)+ completeString(nom.getIndirizzo(),40);
            nom1.addElement(s);
        }
        return nom1;
    }
    public String completeString(String in, int totLen) {
        int diff;
        int size =in.length(); 
        if (totLen > size) {
            diff = totLen - size;
            for (int i=0; i<diff; i++)
                in = in + " ";
        }
        return in; 
    }
}
