/**
 * Singleton design pattern
 *
 * Note how the instance is created and the private constructor
 */


class Singleton {
  private static Singleton s = new Singleton(47);
  private int i;
  private Singleton(int x) { 
    i = x; 
  }
  public static Singleton Instance() { 
    return s; 
  }
  public int getValue() { 
    return i; 
  }
  public void setValue(int x) { 
    i = x; 
  }
}


public class testSing {
  public static void main(String[] args) {
    Singleton s = Singleton.Instance();
	
    System.out.println("First get value on s: "+ s.getValue());
    
    Singleton s2 = Singleton.Instance();
	s2.setValue(9);
    System.out.println("Second get value on s: "+ s.getValue());

	// Can't do this: compile-time error.
	// Singleton s3 = (Singleton) s2.clone();
	// Singleton s3 = new Singleton(33);	  
  }
} 
