/**
 * Esempio di uso del design pattern Factory Method (variante)
 *
 * Il FactoryMethod() e' getShape()
 * L'interfaccia Product e' Shape
 * Le classi ConcreteProduct sono Circle e Square
 * La classe ConcreteCreator e' CreatorA 
 */

import java.util.*;

interface Shape {  // Product
   void draw();
   void fill();
}

class CreatorA {   // ConcreteCreator
   // il Factory Method e' static, un intero indica quale classe istanziare
   public static Shape getShape(int id) {  // FactoryMethod()
      Shape s = null;    // solo questo metodo conosce la classe da istanziare
      if (id == 1) s = new Square();
	  if (id == 2) s = new Circle();
	  return s;
   }
}

class Circle implements Shape {  // ConcreteProduct
   public void draw() { 
      System.out.println("A circle:  ( )"); 
   }
   public void fill() { 
      System.out.println("A filled circle: (X)");
   }
}

class Square implements Shape {      // ConcreteProduct
   public void draw() { 
      System.out.println("A Square: [ ]"); 
   }
   public void fill() { 
      System.out.println("A filled Square: [X]"); 
   }
}

public class ShapeCreatorTestE {
   public static void main(String args[]) {
      // faccio istanziare una sottoclasse di Shape: non decido qui quale classe istanziare
	  Shape s = CreatorA.getShape(2);

	  s.draw();
	  s.fill();
   }
} 
