/**
 * Esempio di uso del design pattern Factory Method
 *
 * Il FactoryMethod() e' getShape()
 * L'interfaccia Creator e' ShapeCreator
 * L'interfaccia Product e' Shape
 * Le classi ConcreteProduct sono Circle e Square
 * La classe ConcreteCreator e' CreatorA
 */

import java.util.*;

interface Shape {  // Product
   void draw();
   void fill();
}

interface ShapeCreator {      // Creator
   public Shape getShape();   // FactoryMethod()
}

class CreatorA implements ShapeCreator { // ConcreteCreator
   public Shape getShape() {  // override del FactoryMethod()
	  return new Circle();    // solo questo metodo conosce la classe da istanziare
  }
}

class Circle implements Shape {   // ConcreteProduct
   public void draw() { 
      System.out.println("A circle:  ( )"); 
   }
   public void fill() { 
      System.out.println("A filled circle: (o)");
   }
}

class Square implements Shape {   // ConcreteProduct
  public void draw() { 
    System.out.println("A Square: [ ]"); 
  }
  public void fill() { 
    System.out.println("A filled Square: [X]"); 
  }
}

public class ShapeCreatorTestC {
  public static void main(String args[]) {
    // istanzio un Creator
	ShapeCreator sc = new CreatorA();
    // faccio istanziare una sottoclasse di Shape: non decido qui quale classe istanziare
	Shape s = sc.getShape();

	s.draw();
	s.fill();
  }
} 
