/**
 * Esempio di uso del design pattern Abstract Factory 
 *
 * L'interfaccia AbstractFactory e' Creator
 * Le interfacce AbstractProduct sono Icon e Text 
 * Le classi ProductA sono Circle e Box
 * Le classi ProductB sono English e Japanese
 * La classe ConcreteFactory1 e' Creator1
 * La classe ConcreteFactory2 e' Creator2
 */

import java.util.*;

interface Icon {    // AbstractProductA
   void draw();
   void fill();
}

interface Text {    // AbstractProductB
   public void tell();
   public void shout();
}

interface Creator {        // AbstractFactory
   public Icon getIcon();  // create method
   public Text getText();
}

class Creator1 implements Creator { // ConcreteFactory
   public Icon getIcon() {
	  return new Circle();
   }
   public Text getText() {
	  return new Japanese();
   }
}

class Creator2 implements Creator { // ConcreteFactory
   public Icon getIcon() {
	  return new Box();
   }
   public Text getText() {
	  return new English();
   }
}

class Circle implements Icon {      // ProductA1
   public void draw() { 
      System.out.print("( ) "); 
   }
   public void fill() { 
      System.out.print("(o) ");
   }
}

class Box implements Icon {       // ProductA2
   public void draw() { 
      System.out.print("[ ] ");
   }
   public void fill() { 
      System.out.print("[X] ");
   }
}

class Japanese implements Text {  // ProductB1
   public void tell() { 
      System.out.println("( Youkoso. Konnichiwa! Hajimemashite )"); 
   }
   public void shout() { 
      System.out.println("( Shizukanishite kudasai )"); 
   }
}

class English implements Text {   // ProductB2
   public void tell() { 
      System.out.println("::::: Welcome. Nice to meet you :::::"); 
   }
   public void shout() { 
      System.out.println("::::: Be quiet please! :::::"); 
   }
}

public class AbsFactorTest {
  public static void main(String args[]) {
    // istanzio un Creator
	Creator c = new Creator1();

	Icon ic = c.getIcon();
    Text t = c.getText();
	
	ic.draw();
	t.tell();	
	
	ic.fill();
	t.shout();
  }
} 
