#include <conf.h>
#include <kernel.h>
#include <tty.h>

/* edit.h */

#define COLOR                   /* define COLOR or MONO for Hercules */

typedef struct texels {         /* text elements for direct screen output */
    unsigned char ch;
    unsigned char attr;
}  texel;

typedef texel scr[25][80];   /* screen array */

/* mono cards */

#ifdef MONO
#define SCRBASE 0xb0000000L;
#endif

/* any color card */

#ifdef COLOR
#define SCRBASE 0xb8000000L
#endif

scr *scrbp = (scr *) SCRBASE;

#define SCREEN (*scrbp)


int   show(buf, r, n)       /* buffer pointer, starting row, no. of rows */
char    *buf;
int     r, n;               /* r=logical row, n=number of lines to write */
{
    int c, bi, cols, dev, ps;
    struct tty *iptr;

    if (isatty(dev=getstdo()) ) {
        iptr = &tty[dev];
        cols=iptr->colsiz;
    } else return SYSERR;
    
    disable(ps);
    bi = r*cols;
    r = r+iptr->topleft.row;        /* border adjustment already done */
    n = r + n;                      /* r and n are now physical */
    for (; r<n; r++) 
        for (c=iptr->topleft.col; c<cols ; c++) 
            SCREEN[r][c].ch = buf[bi++];   /* write directly to screen buf */
    restore(ps);
    return OK;        
}

