/* pcscreen.c - putcsrpos, scrollup, putchr */

#include <dos.h>
#include <conf.h>
#include <kernel.h>
#include <window.h>
#include <vidio.h>

#define INT10H(r)	vidint(&(r))

#define UNSIGNED(x)	  ( *( (unsigned int *) &(x) ) )	/* alias! */

#define SCSRPOS	2
#define SCRLUP	6
#define WCHR	10

/*------------------------------------------------------------------------
 *  putcsrpos  --  put the cursor at a given position
 *------------------------------------------------------------------------
 */
putcsrpos(csr,page)
CURSOR csr;
unsigned page;
{
	union REGS r;
    int ps;

	AH(r)=SCSRPOS;
	DX(r)=UNSIGNED(csr);
	BH(r)=page;
	INT10H(r);
    disable(ps);
}

/*------------------------------------------------------------------------
 *  scrollup  --  scroll a window up
 *------------------------------------------------------------------------
 */
scrollup(tl,br,lines,attr)
CURSOR tl,br;
unsigned lines;
unsigned char attr;
{
	union REGS r;
    int ps;
    
	AH(r)=SCRLUP;
	AL(r)=lines;
	CX(r)=UNSIGNED(tl);
	DX(r)=UNSIGNED(br);
	BH(r)=attr;
	INT10H(r);
    disable(ps);
}

/*------------------------------------------------------------------------
 *  putchr  --  put character at current cursor position
 *------------------------------------------------------------------------
 */
putchr(ch,count,page)
char ch;
unsigned count,page;
{
	union REGS r;
    int ps;

	AH(r)=WCHR;
	AL(r)=ch;
	CX(r)=count;
	BH(r)=page;
	INT10H(r);
    disable(ps);
}
