/* mem.c  -  mem */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <dos.h>

/*------------------------------------------------------------------------
 *  mem  --  check memory 
 *------------------------------------------------------------------------
 */
void mem()
{
	char *pp;
	BLKADDR_T p;
	size_t total, lp;
	u32_t ltotal;
	unsigned int nh;
	int ps;

	disable(ps);
	total = 0;
	nh = 0;
	p = memlist.mnext;
	while ( p != 0 ) {
		nh++;
		pp = BLK2ADDR(p);
		lp = memlen(pp);
		kprintf("Hole %3u at block %6u (%P=0x%05lx), ",
		       nh, p, pp, LINADDR(pp));
		kprintf("large %5u blocks (%lu bytes) \n",
		       lp, ((u32_t) lp) << BLKDIM);
		total += lp;
		p = memnext(pp);
	}
	kprintf("---------------------------------------------------------\n");
	if ( total != memlist.mlen )
        printf("\n ** inconsistent memory allocation **\n");
	ltotal = ((unsigned long)total) << BLKDIM;
	printf("total memory available:%lu\n", ltotal);
	restore(ps);
}
