/* kprintf.c - kprintf */

#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <vidio.h>

/*------------------------------------------------------------------------
 *  kprintf  --  kernel printf: formatted, unbuffered output to the screen
 *------------------------------------------------------------------------
 */
int kprintf(const char * fmt, int args)		/* Derived by Bob Brown, Purdue U.	*/
{
	void kputc(int);
	int	pcx;

	xdisable(pcx);
	_doprnt(fmt, &args, kputc, CONSOLE);
	xrestore(pcx);
	return(OK);
}
