/* getdtime.c - getdtime */

#include <conf.h>
#include <kernel.h>
#include <dos.h>

/*------------------------------------------------------------------------
 *  getdtime  -  get DOS time in 1/100 seconds (past midnight)
 *------------------------------------------------------------------------
 */
SYSCALL getdtime(timvar)
long	*timvar;
{
    union REGS regs;
    int ps;
    
    regs.h.ah = 0x2C;   /* DOS get time */
    disable(ps);
    intdos(&regs, &regs);
    restore(ps);
    *timvar = (long) regs.h.ch * 3600L;
    *timvar = *timvar + (long) regs.h.cl * 60L;
    *timvar = *timvar + (long) regs.h.dh;
    *timvar = *timvar * 100L;
    *timvar = *timvar + (long) regs.h.dl;    
	return(OK);
}
