/* butler.c - butler */

#include <conf.h>
#include <kernel.h>
#include <butler.h>

/*------------------------------------------------------------------------
 *  butler  --  general housekeeping process.  Responds to messages and
 *	takes appropriate actions.  Messages recognized are:
 *		MSGKILL		- kill the system
 *		MSGPSNAP	- print a process table snapshot
 *		MSGTSNAP	- print tty structure snapshot
 *		MSGDSNAP	- print disk snapshot
 *------------------------------------------------------------------------
 */

PROCESS butler()
{
	int	pcx;
    long msg;

//	immortal(getpid());
	for (;;) {
		msg = receive();
		xdisable(pcx);
		switch (msg) {		// wait for & get the message
		case MSGKILL:
			xrestore(pcx);
			xdone();
			break;			// should never get here
		case MSGPSNAP:
			psnap(FALSE);
			break;
#ifdef Ntty
		case MSGTSNAP:
			tsnap();
			break;
#endif
#ifdef Ndsk
		case MSGDSNAP:
			dsnap();
			break;
#endif
		default: 
			kprintf("Butler: message %U not handled\n", msg);
		}
		kprintf("\nButler: press any key to continue . . .");
		kgetc(0);
		kprintf("\n");
		xrestore(pcx);
	}
}
