/* test.c -- test */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <sleep.h>

/*-----------------------------------------
 * test -- function test 
 *-----------------------------------------
*/
int x_dir(nargs, args)
int nargs;
char *args[];
{
    struct dir {                /* DOS directory structure */
        char reserved[21];
        char attr;
        int  time;
        int  date;
        long size;
        char name[13];
    };
    
#define ATTR 0x16               /* attribute hidden, system, subdir */   
    
    int result;
    struct dir *dta;
	int dtalen;
    
    dta = getmem(dtalen = sizeof(struct dir)); /* get disk transfer area*/
    dos_setdta(dta);
    if (nargs > 1) {
        result = dos_ffirst(args[1], ATTR);
        if (result == 1) {
            printf("%s %13s %9D\n", (dta->attr == 16) ? "DIR":"   " ,
                    dta->name, dta->size);
        }
        else {
            printf("%s not found\n", args[1]);
			freemem(dta,dtalen);
            return OK;
        }           
    }
    else {
        result = dos_ffirst("*.*", ATTR);
        while ((result = dos_fnext()) == 1) {
        printf("%s %13s %9D\n", (dta->attr == 16) ? "DIR":"   ",
                 dta->name, dta->size);    
        }
    }
	freemem(dta,dtalen);
    return OK;
}
