/* x_status.c - x_status */

#include <conf.h>
#include <kernel.h>
#include <proc.h>

#define PAD "                                   "



extern	char	vers[];
LSYSCALL mem();

/*------------------------------------------------------------------------
 *  x_status  -  print system status at given intervals
 *------------------------------------------------------------------------
 */
COMMAND x_status(nargs, args)
int     nargs;
char	*args[];
{
	char	str[128];
	char	temp[32];
	int	i = 0;
	int	t;
	long	now;
	
	if (nargs==2) 
		t=atoi(args[1]);
	else t=2;                           /* default is 2/10 seconds */
		
	while (TRUE) {

		strcpy(&str[i],"            ");
		str[12]='\0';        
		sprintf(temp,"%3d Procs ", numproc);
		strcat(str, temp);
		sprintf(temp," %6D [%2d] ", mem(), getpid());
		strcat(str, temp);
		gettime(&now);
		ascdate(now, temp);
		strcat(str, &temp[12]);
#ifdef WINDOWS
		if (isatty(getstdo()) ) {
			strcat(str, PAD);
			show(str,0,1);
		} else 
#endif
			printf(" %s\n",str);
		sleept(t);
	}
}

