/* x_di.c - x_di */

#include <conf.h>
#include <kernel.h>
#include <io.h>


/*------------------------------------------------------------------------
 *  x_di  -  (command di) reinitialize a device
 *------------------------------------------------------------------------
 */
COMMAND x_di(nargs, args)
int	nargs;
char	**args[];
{
	int ps, dev;

	if (nargs != 2) {
		fprintf(STDERR, "di: device initialize\n");
		fprintf(STDERR,"usage: di dev\n");
		return(SYSERR);
	}
	args++;
	if ((dev=getdev(*args)) == SYSERR) {
		fprintf(STDERR,"di: %s is not a device\n",*args);
		return(SYSERR);
	}
	init(dev,UNINIT);		// uninitialize first
	init(dev,INIT);			// now initialize it
	fprintf(STDERR,"\n");	// skip over the error message
	return(OK);
}
