/* x_devs.c - x_devs */

#include <conf.h>
#include <kernel.h>
#include <dos.h>
#include <io.h>

LOCAL char hd1[] =
	"Num Device     mdev port ivec ovec   ioblk   refct\n";
LOCAL char hd2[] =
	"--- ---------  ---- ---- ---- ---- --------- -----\n";

/*------------------------------------------------------------------------
 *  x_devs  --  (command devs) print main fields of device switch table
 *------------------------------------------------------------------------
 */
COMMAND x_devs(nargs, args)
int nargs;
char *args[];
{
	struct devsw *dvp;
	char str[80];
	int i;

	if ( nargs != 1 ) {
		fprintf(STDERR,"Usage: devs\n");
		return(SYSERR);
	}
    write(STDOUT, hd1, strlen(hd1));
    write(STDOUT, hd2, strlen(hd2));
    for (i = 0 ; i < NDEVS ; i++) {
		dvp = &devtab[i];
        sprintf(str, "%2d. %-9s  %4d %04x %04x %04x %P %5d\n",
			i, dvp->dvnam, dvp->dvminor,dvp->dvport, 
			dvp->dvivec, dvp->dvovec,
			dvp->dvioblk, dvp->dvrefct);
		write(STDOUT, str, strlen(str));    
	}
}
