/* x_date.c - x_date */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <sleep.h>

/*------------------------------------------------------------------------
 *  x_date  -  (command date) print the date and time
 *------------------------------------------------------------------------
 */
COMMAND	x_date(nargs, args)
int	nargs;
char	*args[];
{
	char	*str;
	long	now;

	if ( nargs != 1 ) {
		fprintf(STDERR,"Usage: %s\n",args[0]);
		return(SYSERR);
	}
	if ((str=getmem(128)) == NULL) {
		fprintf(STDERR,"date: out of memory\n");
		freemem(str,128);
		return(SYSERR);
	}
    gettime(&now);
    ascdate(now, str);
    write(STDOUT, str, strlen(str));
    fprintf(STDOUT,"\n");
	freemem(str,128);
	return(OK);
}
