/* cmd.c */

#include <conf.h>
#include <kernel.h>
#include <shell.h>
#include <cmd.h>

/*  Initialize shell command structure */

extern	int
	x_bpool(),
	x_cat(),
	x_chdsk(),
	x_chwin(),
	x_clear(),
	x_close(),
	x_color(),
	x_conf(),
	x_cp(),
	x_date(),
	x_devs(),
	x_di(),
	x_dir(),
	x_dos(),
	x_dskst(),
	x_echo(),
	x_edit(),
	x_exit(),
	x_format(),
	x_goto(),
	x_help(),
	x_int(),
	x_kill(),
	x_ls(),
	x_memstat(),
	x_more(),
	x_mount(),
	x_pipstat(),
	x_ps(),
	x_redraw(),
	x_rm(),
	x_shell(),
	shell(),
	x_sleep(),
	x_status(),
	x_timerq(),
	x_ttyst(),
	x_unmou(),
	x_wc(),
	x_window();

struct cmdent cmds[] = {
/* name     Builtin ?   Stack       Priority        Procedure   */

"bpool",    FALSE,      SHCMDSTK,   SHCMDPRI,       x_bpool,
"cat",      FALSE,      SHCMDSTK,   SHCMDPRI,       x_cat,
"clear",    FALSE,      SHCMDSTK,   SHCMDPRI,       x_clear,
"close",    FALSE,      SHCMDSTK,   SHCMDPRI,       x_close,
"color",    FALSE,      SHCMDSTK,   SHCMDPRI,       x_color,
"conf",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_conf,
"cp",       FALSE,      SHCMDSTK,   SHCMDPRI,       x_cp,
"date",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_date,
"devs",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_devs,
#ifdef Ndos
"dir",      FALSE,      SHCMDSTK,   SHCMDPRI,       x_dir,
#endif
"dos",      TRUE,       SHCMDSTK,   SHCMDPRI,       x_dos,
"echo",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_echo,
"exit",     TRUE,       SHCMDSTK,   SHCMDPRI,       x_exit,
"goto",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_goto,
"help",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_help,
"home",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_goto,
"kill",     TRUE,       SHCMDSTK,   SHCMDPRI,       x_kill,
"man",      FALSE,      SHCMDSTK,   SHCMDPRI,       x_help,
"memstat",  FALSE,      SHCMDSTK,   SHCMDPRI,       x_memstat,
"more",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_more,
"mount",    FALSE,      SHCMDSTK,   SHCMDPRI,       x_mount,
#ifdef Npip
"pipstat",  FALSE,      SHCMDSTK,   SHCMDPRI,       x_pipstat,
#endif
"ps",       FALSE,      SHCMDSTK,   SHCMDPRI,       x_ps,
"rm",       FALSE,      SHCMDSTK,   SHCMDPRI,       x_rm,
"sleep",    FALSE,      SHCMDSTK,   SHCMDPRI,       x_sleep,
"status",   FALSE,      SHCMDSTK,   SHCMDPRI,       x_status,
"time",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_date,
"ttystat",  FALSE,      SHCMDSTK,   SHCMDPRI,       x_ttyst,
"unmount",  FALSE,      SHCMDSTK,   SHCMDPRI,       x_unmou,
"wc",       FALSE,      SHCMDSTK,   SHCMDPRI,       x_wc,
"?",        FALSE,      SHCMDSTK,   SHCMDPRI,       x_help,
"sh",       FALSE,      SHCMDSTK,   SHCMDPRI,       shell
#ifdef Ndos
#ifdef WINDOWS
"chwin",    TRUE,       SHCMDSTK,   SHCMDPRI,       x_chwin,
"edit",     FALSE,      SHCMDSTK,   SHCMDPRI,       x_edit,
"redraw",   TRUE,       SHCMDSTK,   SHCMDPRI,       x_redraw,
"shell",    TRUE,       SHCMDSTK,   SHCMDPRI,       x_shell,
"window",   FALSE,      SHCMDSTK,   SHCMDPRI,       x_window,
#endif
#endif
};

int ncmds = sizeof(cmds)/sizeof(struct cmdent);
