/* nammapd.c - nammapd */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <name.h>

/*------------------------------------------------------------------------
 *  nammapd  -  using namespace, iteratively map name onto device 
 *------------------------------------------------------------------------
 */
SYSCALL	nammapd(name)
char	*name;
{
	int 	ps,i;
	int	dev;
	char	*newname, *tmpnam;

    if ((tmpnam=getmem(NAMLEN)) == NULL)
		return(SYSERR);
    if ((newname=getmem(NAMLEN)) == NULL) {
		freemem(tmpnam,NAMLEN);
		return(SYSERR);
	}
	disable(ps);
	dev = namrepl(newname, name);
	while (dev == NAMESPACE) {
		strcpy(tmpnam, newname);
		dev = namrepl(newname, tmpnam);
	}
	freemem(newname,NAMLEN);
	freemem(tmpnam, NAMLEN);
	restore(ps);
	return(dev);
}
