/* map.c - mapinit, maprestore */

/* always called with int disabled */

#include <dos.h>
#include <conf.h>
#include <kernel.h>
#include <io.h>

extern struct intmap_t *intmap;	// _intmap in intmap.asm

/*------------------------------------------------------------------------
 *  mapinit  --  fill in an intmap table entry using DOS getvect, setvect
 *------------------------------------------------------------------------
 */
int mapinit(vec,newisr,mdevno)
int vec;			// low byte = interrupt vector no., hi byte = intmap flag
isr_t newisr;		// addr. of new service routine
int mdevno;			// normally minor device number, in general ISR argument
{
	struct intmap_t *imp;	// will point to intmap
	char * isr_entry_p;
	int flag;				// upper byte of vector
	union REGS regs;
	struct SREGS sregs;
	int ps;

	if ( nmaps >= NMAPS )	// global nmaps is no. of
		return(SYSERR);		// next intmap entry to be used
	imp = &intmap[nmaps++];	// point to clean intmap entry

	/* Note intmap is _intmap in intmap.asm, and points to
	 * array intmap in intmap.asm
	 */

	flag = (vec>>8) & 0xff;	// pick up flag byte
	vec = vec & 0xff;		// only low-order byte counts

	/* set up the input intmap entry */
	imp->biosflag = flag;		// deposit flag byte in biosflag

	/* DOS get_vect */
	AH(regs) = 0x35;				// DOS function
	AL(regs) = vec;					// vector no. operand
	intdosx(&regs,&regs,&sregs);
	imp->oldisr = OLDISR(sregs,regs);
	disable(ps);					// be SURE ints are off

	/* DOS set_vect */
	AH(regs) = 0x25;				// DOS function
	AL(regs) = vec;					// vector no. operand
	isr_entry_p = &imp->callinst;
	NEWISR(sregs,regs,isr_entry_p);
	intdosx(&regs,&regs,&sregs);
	disable(ps);					// be SURE ints are off

	imp->newisr = newisr;		// store Xinu interrupt handler in intmap
	imp->mdevno = mdevno;		// minor device no.
	imp->ivec = (char) vec;		// interrupt vector
	return(OK);
}

/*------------------------------------------------------------------------
 *  maprestore  --  restore all old interrupt vectors from the intmap
 *------------------------------------------------------------------------
 */
int maprestore()
{
	int i;					// count intmap entry number
	struct intmap_t *imp;	// points to intmap
	union REGS regs;
	struct SREGS sregs;
	int ps;

	if ( nmaps > NMAPS )
		nmaps = NMAPS;		// just to be sure
	for (i = 0; i < nmaps; i++) {
		imp = &intmap[i];	// point to this intmap entry
		if ( (int)(imp->newisr) == -1 )
			continue;		// if unused entry

		/* DOS set_vector */
		AH(regs) = 0x25;
		AL(regs) = imp->ivec;
		NEWISR(sregs,regs,imp->oldisr);
		intdosx(&regs,&regs,&sregs);
		disable(ps);		// be SURE ints are off
	}
	return OK;
}
