/* isownstk.c -- is_own_stk
 *
 * check if argument points within original stack of current process;	*
 */

/* ** call only with ints disabled ** */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <dos.h>
#include <io.h>


int is_own_stk(char * ptr)
{
	u32_t laddr;
	u32_t proc_stk_base, proc_stk_lim;
	int ret;

/* The stack allocated for a process has this structure 					*
 * NB: Intel stacks grow upwards (i.e. sp decreases), low addresses at 		*
 * right in figure															*
 *				 .....[       <--[|||||||||||||||||||||||||||] ......		*
 *		   		 pbase	      top      process' stack         pbase+ssize	*
 *																			*
 * pbase and ssize (stack max size) are process table fields.				*   
 * Note pbase = base of process' memory, NOT stack (it is the stack limit)	*
 */
	proc_stk_lim = LINADDR(proctab[currpid].pbase);
	proc_stk_base = proc_stk_lim + proctab[currpid].ssize;

 /* if ptr lies between proc_stk_lim and proc_stk_base, it points within		*
  * the stack allocated initially, and ret will be 1, otherwise ret will be 0.	*
  * This could be inaccurate, however, if stack overflow occurs.				* 
  */
	ret = (  (laddr = LINADDR(ptr))
	         >= proc_stk_lim  ) 
	      && (laddr <= proc_stk_base);

	return(ret); 
}
