/* getmem.c - getmem */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <dos.h>

/*------------------------------------------------------------------------
 *  getmem -- allocate storage (first fit), returns lowest integer address
 *------------------------------------------------------------------------
 */

char *getmem(nbytes)
size_t nbytes;
{
	int ps;
	char *pp, *qp, *leftp;	// puntatori
	BLKADDR_T p, left;		// indirizzi blocco in n. paragrafo/segmento
	size_t alloc, notalloc;

	/* round requested nbytes to next para and convert to
	 * requested paragraphs
	 */
	alloc = roundp(nbytes) >> BLKDIM;		// n. blocchi da allocare
	if ( alloc == 0)
        return(NULL);
	disable(ps);

	/* memlist:		primo (fittizio) nella lista dei blocchi liberi		*
	 * qp:			machine address ultimo blocco controllato			*
	 * pp,p:		machine address/n.segmento blocco da controllare	*
	 * left,leftp:	all'uscita, machine address/n.segmento del frammento*
	 *					rimasto del blocco allocato						*
	 */
	qp = (char *) &memlist;
	for (;;) {
		p = memnext(qp);		// scan list of memory blocks
		if ( p == 0 ) { 		// no suitable block found
			restore(ps);
			return(NULL);
		}
		pp = BLK2ADDR(p);		// memp(p) = indirizzo far base segmento p
		if ( memlen(pp) < 
		     alloc ) {			// block too small
			qp = pp;			// prepare to check next block
			continue;			// retry
		}
		// block found
		notalloc = memlen(pp) -			// must be >= 0
		           alloc;		
		if ( notalloc == 0 ) { 			// exact match
			left = memnext(pp);			// no fragment
			break;
		}
		/* must break up block */
		left = p + alloc;				// n.segmento del frammento
		leftp = BLK2ADDR(left);			// far addr frammento
		memnext(leftp) = memnext(pp);	// assegna valori ai campi
		memlen(leftp) = notalloc;		// del blocco/frammento
		break;
	}
	memnext(qp) = left;				// aggancia frammento in memlist 
	memlist.mlen -= alloc;			// aggiorna blocco di testa
	restore(ps);					// (contiene dim. mem. libera
    return(pp);
} 

/* It is essential to note, that, with the huge model, getmem returns,	*
 * by using BLK2ADDR, a far pointer pp with zero offset. This permits	* 
 * stack overflow checking as in resched().								*
 */
