/* freemem.c - freemem */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <dos.h>

/*------------------------------------------------------------------------
 *  freemem  --  free a memory block, returning it to memlist
 *------------------------------------------------------------------------
 */
SYSCALL freemem(bp, size)
char *bp;
size_t size;
{
	int ps;
	char *pp, *qp;
	BLKADDR_T b, p, q, top;
	size_t retsize;

	retsize = roundp(size) >> BLKDIM;
	if ( retsize == 0 || bp == NULL || NOTATBLK(bp) )
		return(SYSERR);
	b = ADDR2BLK(bp);
	if ( b < lowbaddr || b > hibaddr || (hibaddr-lowbaddr) < retsize )
		return(SYSERR);
	disable(ps);
	q = 0;
	qp = (char *) &memlist;
	p = memnext(qp);
	while ( p != 0 && p < b ) {
		q = p;
		qp = BLK2ADDR(q);
		p = memnext(qp);
	}
	if ( q != 0 && (top = q + memlen(qp)) > b ) {
		restore(ps);
		return(SYSERR);		// q<b, but block q overlaps b!
	}
	if ( p != 0 && b + retsize > p ) {
		restore(ps);
		return(SYSERR);		// b<p, but block b overlaps p!
	}
	if ( q != 0 && top == b )
		memlen(qp) += retsize;	// consolidate q & b blocks
	else { 
	// q == 0, top meaningless, and qp == &memlist
	// or q != 0 and top < b
		memlen(bp) = retsize;	// initialize block b
		memnext(bp) = p;		// link from b to p
		memnext(qp) = b;		// link from q to b, if q != 0
								// otherwise let memlist point to b
		q = b;					// let q point to
		qp = bp;				// newly freed block
	}							
	// here q points to new block (b) or has been widened by b
	if ( p != 0 && q+memlen(qp) == p ) {
		pp = BLK2ADDR(p);		/* consolidate q & p blocks	*/
		memlen(qp) += memlen(pp);
		memnext(qp) = memnext(pp);
	}
	memlist.mlen += retsize;
	restore(ps);
	return(OK);
}
