/* die.c - die */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <sem.h>
#include <dos.h>
#include <mem.h>
#include <io.h>

/*--------------------------------------------------------------------------
 * die  --  terminate process and remove it from system, set as trap by kill
 *--------------------------------------------------------------------------
 */
SYSCALL die(pid)
int pid;
{
	struct pentry *pptr;
	int i;
	int ps;
	int nok;

	disable(ps);
//	should check whether pid is bad!!
    pptr = &proctab[pid];
	pptr->pprio = MAXINT;		/* make sure we go away fast	*/

	/* close process' devices */
	for (i=0 ; i<Nsio ; i++)
		close(pptr->pdevs[i]);

	/* inform next of kin about death */
	nok = pptr->pnxtkin;
	pptr->pnxtkin = BADPID;
    if ( nok != pid )
        send(nok, pid);

	/* free allocated memory */

/*	N.B.: avendo rinunciato agli XBLOCK, devo almeno liberare il blocco
 *	di memoria allocata da create() per il processo che ora muore.
 *	Credo che questo blocco sia concatenato con lo slot pmlist, se si
 *	usano gli XBLOCK
 */
	freemem(pptr->pbase, pptr->plen);

	if ( --numproc == 0 )	// if this was last process
		xdone();			// terminate Xinu
	pptr->pstate = PRFREE;	// free process' slot
	resched();
	kprintf("Warning: returning to resched() within die()\n");
	restore(ps);			// should never get here
	return OK;
}