; xeidi.asm - _sys_xdisabl, _sys_xrestor, _sys_pcxget, _sys_getstk

	public	_sys_xdisabl, _sys_xrestor, _sys_pcxget,
	public	pcxflag

include	..\h\dos.asm

pseg

pcxflag	dw	1	; zero when rescheduling disabled

; pcxflag e` gestito direttamente da alcuni moduli assembler,
; via queste routine (e macro in kernel.h) dai processi comuni

;-------------------------------------------------------------------------
; _sys_xdisabl  --  return pcxflag & disable context switching
;-------------------------------------------------------------------------
; int sys_xdisabl()
_sys_xdisabl	proc
	pushf
	cli		; disable interrupts
	xor	ax,ax
	xchg	ax,cs:pcxflag
	popf
	ret
_sys_xdisabl	endp

;-------------------------------------------------------------------------
; _sys_xrestor  --  restore pcxflag
;-------------------------------------------------------------------------
; sys_xrestor(int pcx)
_sys_xrestor	proc
	push	bp
	mov	bp,sp		; C calling convention
	pushf
	cli			; disable interrupts
	mov	ax,[bp+6];	; get parameter (pcxflag to restore)
	mov	cs:pcxflag,ax   ; restore pcxflag to parameter
	popf
	pop	bp
	ret
_sys_xrestor	endp

;-------------------------------------------------------------------------
; _sys_pcxget  --  get the current value of pcxflag
;-------------------------------------------------------------------------
; int sys_pcxget()
_sys_pcxget	proc
	pushf
	cli			; disable interrupts
	mov	ax,cs:pcxflag
	popf
	ret
_sys_pcxget	endp

endps

	end
