/* xdone.c - xdone */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <io.h>
#include <disk.h>
#include <tty.h>
#include <q.h>

extern char *lowptr;
extern int run;

/*------------------------------------------------------------------------
 *  xdone  --  print system termination message and terminate PC-Xinu
 *------------------------------------------------------------------------
 */
SYSCALL xdone()
{
	int ps, pcx, i;
	void free(char *);		// from DOS library

#ifdef Ndsk
	for ( i=0; i<Ndsk; i++ )
		control(dstab[i].dnum,DSKSYNC);	// sync the disks
#endif

#ifdef Nsio
	sleep(1);                           // let tty output settle
#endif

	disable(ps);
	xdisable(pcx);				// no use for current code (resched not called)
	
	for (i = 0 ; i < NDEVS ; i++)	
		if (init(i,UNINIT) != OK)	// un-initialize device
			kprintf("xdone: error un-initializing device %d\n", i);

	kprintf("\n\n-- system halt, ");
	kprintf("returning to DOS . . .\n\n");
	kprintf("Processes still active on termination\n");
	disable(ps); 		// to be sure!

	maprestore();		// restore DOS interrupt vectors
	// dealloc DOS memory; this process (but not null, see INITIALI.C) 
	// will now run in freed memory!
	free(lowptr);		// free() is from the compiler's host OS library
	disable(ps); 		// to be sure!

/* Actual termination is rather tricky: setting run to FALSE terminates the	*
 * null process and also routine main() (INITIALI.C); this (through the C	*
 * compiler code) will return to the host OS cleaning up stack and flags.	*
 * Original code does not give null process max priority, so it works only	*
 * if no process except null is ready; e.g. in l3x, xmain, executing the 	*
 * shell would be waiting on a semaphore (to read command line), but in		*
 * ex2.c, two non-terminating processes would keep scheduling each other by	*
 * calling resched().														*
 */
	run = FALSE;		// terminate null process in main() (INITIALI.C)
	dequeue(NULLPROC);					// give null process
	proctab[NULLPROC].pprio = MAXINT;	// max priority
	insert(NULLPROC, rdyhead, MAXINT);
	xrestore(pcx);
//	kprintf("%c", 7);	// ring bell, to tell we are about to reschedule
	resched();
/* Note: without resched() above, after xdone(), the process that called it	* 
 * must reschedule, so the null process has a chance to run and terminate.	*
 * A way of ensuring this is the process doing a (maybe implicit) return, 	*
 * hence a userret, which will kill it, and then call resched().			*
 */
	return OK;			// shouldn't get here, because of resched()
}
