/* panic.c - panic, exc_isr */

#include <dos.h>
#include <conf.h>
#include <kernel.h>
#include <xtypes.h>
#include <proc.h>
#include <io.h>
#include <tty.h>
#include <pc.h>


/*------------------------------------------------------------------------
 *  panic  --  print error message and terminate PC-Xinu
 *------------------------------------------------------------------------
 */
int panic(const char * cp)
{
	int pid;
	int	ps;
	int psnap(Bool);

	disable(ps);
	pid = getpid();
	psnap(0);
	kprintf("\n\n-- panic stop (pid=%d) --\n%s\n\n", pid, cp);
	restore(ps);
	xdone();		// terminate Xinu, back to host OS
	return OK;		// shouldn't get here
}

#define MAXSPRINT	6		/* max stack values to print	*/

static int i;				/* counter for printing stack	*/
static char *ep;			/* error message pointer	*/
static struct pentry *pp;	/* pointer to this proc. entry	*/
static WORD *sp;			/* interrupted code's stack pointer */

extern void (* usrpanic)();

/*------------------------------------------------------------------------
 *  exc_isr  --  exception handler, called by exception interrupts
 *------------------------------------------------------------------------
 */
exc_isr(typ,bp)
int typ;		// exception type
WORD * bp;		// copy of pointer to base of frame for intcom
{
	/* No locals, to have a clean stack */

	switch (typ) {
	case DB0VEC:
		ep = "Divide by zero";
		break;
	case SSTEPVEC:
		ep = "Single step";
		break;
	case BKPTVEC:
		ep = "Breakpoint";
		break;
	case OFLOWVEC:
		ep = "Arithmetic overflow";
		break;
	default:
		ep = "Unknown interrupt";
	}
	kprintf("\n-- panic stop -- \n");
	kprintf("panic: trap type %d (%s) \n", typ, ep);
	pp = &proctab[currpid];
	kprintf("process pid=%d name=%s \n", currpid, pp->pname);

	/* Stack after exception occurs, just before exc_isr is called by intcom;
	   note bp register at that point is copied to 2nd argument of this
	   function; also note bp+- is pointer arithmetic.

    bp-8 -> es
    bp-7 -> ds
    bp-6 -> di
    bp-5 -> si
    bp-4 -> dx
    bp-3 -> cx
    bp-2 -> bx
    bp-1 -> ax
    bp   -> bp (saved)
    bp+1 -> return address pushed by "call intcom" (within intmap)
    bp+2 -> ip    pushed by the exception
    bp+3 -> cs    pushed by the exception
    bp+4 -> flags pushed by the exception
    bp+5 -> top of the stack for code interrupted when exception occurred

	*/

	sp = bp + 5;
	kprintf("state: ax=%04x bx=%04x cx=%04x dx=%04x",
	                bp[-1], bp[-2], bp[-3], bp[-4]);
	kprintf(      " si=%04x di=%04x bp=%04x ds=%04x es=%04x\n",
	                bp[-5], bp[-6], bp[ 0], bp[-7], bp[-8]);
	kprintf("       flags=%04x              ", bp[4]);
	kprintf(       "cs:ip=%04x:%04x         ss:sp=%P \n\n",
	                bp[3], bp[2],           sp);

	kprintf( "stack dump:   Far addr    Value\n");
	for ( i = 0 ; i < MAXSPRINT ; i++, sp++)
		kprintf("              %P -> \%04x \n", sp, *sp);

	(*usrpanic)();

	kprintf("\nL3X terminated with %d processes active \n", numproc);
	maprestore();
	halt();
	return OK;		// shouldn't get here
}
