/* kill.c - kill */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <sem.h>
#include <dos.h>
#include <q.h>

/*------------------------------------------------------------------------
 * kill  --  kill a process and remove it from the system
 *------------------------------------------------------------------------
 */
SYSCALL kill(pid)
int pid;			/* process to kill			*/
{
	struct pentry *pptr;
	int ps;

	disable(ps);
	if (isbadpid(pid) || 
	    (pptr = &proctab[pid])->pstate == PRFREE) {
		restore(ps);
		return(SYSERR);
	}
	if (pid == currpid)
		die(pid);

	switch (pptr->pstate) {
	case PRWAIT:
		semaph[pptr->psem].semcnt++;
		dequeue(pid);	// pid aspettava sulla coda di un semaforo
		break;
	case PRREADY:
		dequeue(pid);	// solo per ora
		break;
	case PRSLEEP:
	case PRTRECV:
		unsleep(pid);
		break;
	default:
		break;
	}
	/* I processi vengano uccisi rischedulandoli e facendogli
	   eseguire die() attraverso una trap!                    */
	pptr->ptfn = die;			// gia` impostata per default da create()
	pptr->phastrap = TRUE;		// ma con phastrap FALSE
	pptr->ptarg = pid;			// argomento per la trap die()
	pptr->pstate = PRREADY;
	pptr->pprio = MAXINT;		// max priority for process to be killed
	insert(pid,rdyhead,MAXINT);
	resched();
	restore(ps);
	return(OK);
}
