; eidi.asm - _sys_disabl, _sys_enabl, _sys_restor, _sys_wait, _sys_xdone

	include ..\h\dos.asm

	public  _sys_disabl,_sys_restor,_sys_enabl,_sys_wait,_sys_xdone,_sys_psget

pseg

;-------------------------------------------------------------------------
; _sys_disabl  --  return interrupt status and disable interrupts
;-------------------------------------------------------------------------
; int sys_disabl()
_sys_disabl	proc
	pushf			; put flag word on the stack
	cli			; disable interrupts!
	pop	ax		; deposit flag word in return register
	ret
_sys_disabl	endp

;-------------------------------------------------------------------------
; _sys_restor  --  restore interrupt status
;-------------------------------------------------------------------------
; void sys_restor(ps)
; int ps;
_sys_restor	proc
        push    bp
	mov	bp,sp		; C calling convention
	push	[bp+6]		; NB +6 because ret addr is far
	popf			; restore flag word
	pop	bp
	ret
_sys_restor	endp

;-------------------------------------------------------------------------
; _sys_enabl  --  enable interrupts unconditionally
;-------------------------------------------------------------------------
; void sys_enabl()
_sys_enabl	proc
	sti			; enable interrupts
	ret
_sys_enabl	endp

;-------------------------------------------------------------------------
; _sys_wait  --  wait for interrupt
;-------------------------------------------------------------------------
; void sys_wait()
_sys_wait	proc
        pushf
	sti			; interrupts must be enabled here
        hlt
        popf
        ret
_sys_wait	endp

;-------------------------------------------------------------------------
; _sys_xdone  --  halt the current program and return to DOS
;-------------------------------------------------------------------------
; void sys_xdone()
_sys_xdone	proc
	mov	ah,4ch		; terminate function
	xor	al,al		; OK return code
        int     21h             ; MS-DOS function call
        ret
_sys_xdone	endp

;-------------------------------------------------------------------------
; _sys_psget  -- get processor (processor status), call with int disabled
;-------------------------------------------------------------------------
; unsigned sys_psget()
_sys_psget	proc
	pushf			; put flag word on the stack
	pop	ax		; deposit flag word in return register
	ret
_sys_psget	endp

endps

	end
