/* clkint.c - clkint, wakeup */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <q.h>
#include <sleep.h>
#include <io.h>

extern long ticks_10ms;    /* counts in 100ths of second 0-INF  */

/*------------------------------------------------------------------------
 *  clkint  --  clock service routine
 *  called at every clock tick and when starting the deferred clock
 *------------------------------------------------------------------------
 */
INTPROC clkint(mdevno)
int mdevno;				/* minor device number		*/
{
	static int clkinc = 0;
	static int clkinc10 = 0;
	int wakeup(void);

	tod += 5;
	if ( (clkinc10 += 591) >= 1200) {
		ticks_10ms=tod++;
		clkinc10 -= 1200;
	}
/*  Notes on the above: this int is executed about 18.2 times per second.
    After 18 ints, tod=90 but the elapsed time is .9886572 secs. Every so
    often, the if statement above increments tod to make up the lag. Tod
    thus represents the time since startup in hundredths of a second. */

/*	proctab[currpid].time++; */		// increment CPU time used

	if ( (clkinc += TICSD) >= TICSN ) {
		clktime++;
		clkinc -= TICSN;
	}
	if (defclk) {
		clkdiff++;
		return OK;
	}
    if (slnempty)
		if ( --*sltop <= 0 )
			wakeup();
	if ( --preempt <= 0 )
		resched();
	return OK;        
}

/*------------------------------------------------------------------------
 *  wakeup  --  called by clock interrupt dispatcher to awaken processes
 *------------------------------------------------------------------------
 */
LOCAL wakeup(void)
{
	register int makeup;	// makeup for lost time
	register int k;			// key value

	makeup = 0;
	while ( nonempty(clockq) && (k = firstkey(clockq)) <= makeup ) {
		makeup -= k;
		ready(getfirst(clockq));
	}
	if ( slnempty = nonempty(clockq) ) {
		sltop = &firstkey(clockq);
		*sltop -= makeup;
	}
	resched();
	return OK;
}
