/* chprio.c - chprio */

#include <conf.h>
#include <kernel.h>
#include <proc.h>

/*------------------------------------------------------------------------
 *  chprio  --  change the scheduling priority of a process
 *
 *  problema: la priorita` cambia in tabella dei processi, ma non nella
 *  q struct, cioe` nella struttura dati che descrive/descrivera` il 
 *  processo nella coda dei ready!
 *------------------------------------------------------------------------
 */
SYSCALL chprio(pid,newprio)
	int pid;
	int newprio;		// newprio > 0
{
	int oldprio;
	struct pentry *pptr;
	int ps;

	disable(ps);
	if (isbadpid(pid) || newprio <= 0 ||
	    (pptr = &proctab[pid])->pstate == PRFREE) {
		restore(ps);
		return(SYSERR);
	}

	oldprio = pptr->pprio;
	pptr->pprio = newprio;
	restore(ps);
	return(oldprio);
}
