/* mem.h */


#ifndef MEM
#define MEM

#include <xtypes.h>

/* Memory is allocated in blocks of size 2**BLKDIM. 
 */

#define BLKDIM 4
#define BLKSIZ (1 << BLKDIM)
#define BLKSIZ1 ((BLKSIZ)-1)

#define roundp(nbytes) ( (BLKSIZ1 + (size_t) nbytes) & (~BLKSIZ1) )

/* We need two types of addresses, and conversion macros between them:
   - machine addresses, i.e. (char *), which can be dereferenced
   - block addresses, i.e. BLKADDR_T: fake addresses
   Conversion macros are platform-specific (see dos.h)
 */

#define CPUWID 20			// Physical address width
#if ( CPUWID-BLKDIM <= 16 )
typedef u16_t BLKADDR_T;
#else
typedef u32_t BLKADDR_T;
#endif


/* Memory free list implementation */

typedef struct	mblock	{
    BLKADDR_T mnext;// n.paragrafo a 16 bit indirizza 2^16 paragrafi=2^20 byte
    size_t mlen;	// lunghezza blocco
} MBLOCK;
#define memnext(x)	(((MBLOCK *)(x))->mnext)
#define memlen(x)	(((MBLOCK *)(x))->mlen)

#define MMAX 40000L*(BLKSIZ)// max memory size (in bytes)

extern MBLOCK memlist;		// head of free memory list

extern BLKADDR_T hibaddr;	// max memory address
extern BLKADDR_T lowbaddr;	// min memory address

extern char *getmem();
extern int freemem(char *, size_t);

// NB: farmalloc turns interrupt flag on!
// MALLOC() should be called with interrupts already disabled.
#define MALLOC(p,nbytes) \
	(p = farmalloc(nbytes), sys_disabl(), p)


#endif