/* dos.h */

#ifndef XTYPES
#include <xtypes.h>
#endif

#define INT86(n,r)  int86((n),(r),(r))
#define INT86X(n,r,s)  int86x((n),(r),(r),(s))

#define FP_SEG(fp)  ( *( (unsigned *)&(fp) + 1) )
#define FP_OFF(fp)  ( *( (unsigned *)&(fp) ) )		

/* FP_SEG(fp) e FP_OFF(fp) restituiscono, come unsigned, parte alta 
 * e bassa della dword alla locazione fp (che sia o no un far pointer;
 * fp dev'essere un l-value, non un'espressione (gli si applica &). 
 */

#define LINADDR(fp) ((((u32_t) (fp)) >> 16) << 4) + ((u16_t) fp)
#define BLK2ADDR(x) ( (char *) ( ((u32_t) x) << 16 ) )
#define ADDR2BLK(x) ( (WORD) ((LINADDR((x))) >> 4) )

#define NOTATBLK(faddr) ( (int) (((u32_t) faddr) & 0xffffL)) 

#ifdef PROC
#define STACK_OFLOW(pptr) (FP_OFF(pptr->pregs) > (pptr->ssize))
#endif
 
/* How to recognize stack overflow? Process table has fields for stack 	*
 * pointer (pregs), stack upper limit (pbase), and stack size (ssize).	*
 * Apparently, it suffices to check that in the process table			*
 * 			stack_pointer > stack_limit									*
 * However, in far memory model stack_pointer is a far pointer, and its	*
 * decrements wrap-up (XYZW:0000 is decremented to XYZW:FFFF!			*
 * Actually, in Xinu with far pointers stack overflow is circular!		*
 * The solution is based on taking into account that:					*
 * - memory allocated initially starts at pbase of the form XYZW:0000	*
 *   (getmem() in KERNEL/GETMEM.C (see comments) works thus)			*
 * - stack starts at XYZW:ssize (i.e. 64K max), and grows upwards, by	*
 *   decreasing towards XYZW:0000										*
 * Thus if the stack overflows, the offset of the stack pointer wraps	*
 * up and exceeds ssize. Note: exceeds as unsigned (as pptr->ssize and	*
 * FP_OFF(pptr->pregs) are.												*
 * Stack overwlow is checked only at rescheduling (see resched()), and	*
 * before it's caught it can disappear (stack shrinks or grows beyond 	*
 * the base again!).													*
 */

#define MK_FP(seg,ofs)  ((void far *)(((unsigned long)(seg) << 16) | (ofs)))

#define UNSIGNED(x)	  ( *( (unsigned int *) &(x) ) )	/* alias! */

struct WORDREGS	{
	unsigned int ax, bx, cx, dx, si, di, carryflg, flags;
};

struct BYTEREGS	{
	unsigned char al, ah, bl, bh, cl, ch, dl, dh;
};

union	REGS {
	struct	WORDREGS x;
	struct	BYTEREGS h;
};

struct	SREGS	{
	unsigned int es, cs, ss, ds;
};

int intdosx(union REGS *, union REGS *, struct SREGS *);


#define AH(r)		((r).h.ah)
#define AL(r)		((r).h.al)
#define BH(r)		((r).h.bh)
#define BL(r)		((r).h.bl)
#define CH(r)		((r).h.ch)
#define CL(r)		((r).h.cl)
#define DH(r)		((r).h.dh)
#define DL(r)		((r).h.dl)

#define AX(r)		((r).x.ax)
#define BX(r)		((r).x.bx)
#define CX(r)		((r).x.cx)
#define DX(r)		((r).x.dx)
#define SI(r)		((r).x.si)
#define DI(r)		((r).x.di)

#define CARRYFLG(r) ((r).x.carryflg)
#define FLGS(r) ((r).x.flags)

#define CS(r)		((r).cs)
#define SS(r)		((r).ss)
#define DS(r)		((r).ds)
#define ES(r)		((r).es)

/* OLDISR(sregs,regs) returns the far address of the old isr
   NEWISR(sregs,regs,newisr) prepares the registers with the address of the 
   new isr; note that newisr must be an l-value.
 */

#define OLDISR(sregs,regs) MK_FP(sregs.es, regs.x.bx)
#define NEWISR(sregs,regs,newisr) sregs.ds = FP_SEG(newisr); regs.x.dx = FP_OFF(newisr);
