/* sem.h - isbadsem */

#ifndef	NSEM
#define	NSEM 50			/* number of semaphores, if not defined	*/
#endif

#define SFREE '\01'		/* this semaphore is free		*/
#define	SUSED '\02'		/* this semaphore is used		*/

struct	sentry {		/* semaphore table entry		*/
	char sstate;		/* state is \t SFREE or \t SUSED		*/
	int	semcnt;			/* count for this semaphore				*/
	int	sqhead;			/* \t q index of head of semaphore	list	*/
	int	sqtail;			/* \t q index of tail of semaphore list	*/
};

extern struct sentry semaph[];
extern int nextsem;

#define	isbadsem(s)	(s < 0 || s >= NSEM)
