/* q.h - firstid, firstkey, isempty, lastkey, nonempty */

/* q structure declarations, constants, and inline procedures */

/* queue dummy heads and tails start from q entry NPROC;
 * there is a head/tail for semaphore, one for ready processes, 
 * one for sleeping processes
 */
#ifndef NQENT
#define NQENT NPROC+NSEM+NSEM+4
#endif

struct qent {		// one per process plus two per list
	int qkey;		// key on which the queue is ordered
	int qnext;		// pointer to next process or tail
	int qprev;		// pointer to previous process or head
};

extern struct qent q[];		// q array declaration
extern int nextqueue;

/* inline list manipulation procedures */

#define isempty(list)  (q[(list)].qnext >= NPROC)
#define nonempty(list) (q[(list)].qnext < NPROC)
#define firstkey(list) (q[q[(list)].qnext].qkey)
#define lastkey(tail)  (q[q[(tail)].qprev].qkey)
#define firstid(list)  (q[(list)].qnext)

#define EMPTY (-1)	// NULL pointer in a process queue

int insert(int,int,int);
int enqueue(int, int);
int dequeue(int);
int newqueue(void);
int getfirst(int);
int getlast(int);
