/* proc.h - isbadpid */
/* 8086 version */

#ifndef PROC
#define PROC

/* process table declarations and defined constants			*/

#ifndef NPROC				// set the number of processes
#define NPROC	30			// but only if not already set
#endif						// (actually should be set in conf.h)

/* process state constants */

#define PRCURR	'\01'	// process is currently running
#define PRFREE	'\02'	// process slot is free
#define PRREADY	'\03'	// process is on ready queue
#define PRRECV	'\04'	// process waiting for message
#define PRSLEEP	'\05'	// process is sleeping
#define PRSUSP	'\06'	// process is suspended
#define PRWAIT	'\07'	// process on semaphore queue
#define PRTRECV	'\010'	// process is timing a receive

/* miscellaneous process definitions */

#define PNMLEN		9		// length of process "name"
#define NULLPROC	0		// id of the null process
					        //   (always eligible to run)
#define BADPID	(-1)    	// used when invalid pid needed

#define	isbadpid(x)	(x<=0 || x>=NPROC)

/* process table entry */

struct pentry	{
	char	pstate;			// process state: PRCURR, etc.	
	int		(*paddr)();		// initial code address		
	int		pargs;			// initial number of arguments		
	int		pprio;			// process priority	
	char	pname[PNMLEN+1];// process name	
	char	*pregs;			// saved environment for ctxsw	
	char	*pbase;			// process' memory base = upper limit of its stack
	WORD	ssize;			// size of stack	
	WORD	plen;			// stack length in bytes	
	long	oldtime;		// time at which resched made it current	
	long	time;			// CPU time ticks used	
	int		psem;			// semaphore if process waiting	
	long	pmsg;			// message sent to this process	
	int		phasmsg;		// nonzero iff pmsg is valid	
	int 	pnxtkin;		// next-of-kin notified of death	
	int		pdevs[Nsio];	// devices to close upon exit	
	int		pimmortl;		// nonzero iff process immortal		
	int		(*ptfn)();		// trap function	
	int		phastrap;		// nonzero iff trap is pending	
	int		ptarg;			// argument to ptfn		
};

extern	struct	pentry proctab[];
extern	int		numproc;	// currently active processes	
extern	int		nextproc;	// search from here for free process slot	
extern	int		currpid;	// currently executing process

#endif