/* kernel.h */
/* 8088 PC-Xinu version - for IBM PC and Clones */

/* Symbolic constants used throughout Xinu */

#include <xtypes.h>

#define EMPTY		(-1)		/* an illegal gpq		*/
#define LSYSCALL	long		/* Syscall returning a long	*/
#define SYSCALL		int			/* System call declaration	*/
#define LOCAL		static		/* Local procedure declaration	*/
#define INTPROC		int			/* Interrupt procedure  	*/
#define PROCESS		int			/* Process declaration		*/
#define COMMAND		int			/* Shell command declaration	*/
#define BUILTIN		int			/* Shell builtin ""		*/
#define MINSTK		0x400		/* minimum process stack size	*/
#define NULLSTK		0x1000		/* process 0 stack size		*/
#define OK		 	1 			/* returned when system call ok	*/
#define SYSERR		-1			/* returned when sys. call fails*/
#define EOF			-2			/* End-of-file (usu. from read)	*/
#define TIMEOUT		-3L			/* time out (usu. recvtime) */
#define TMSGINT		-4L			/* keyboard "intr" key pressed (usu. ^B) */
#define TMSGKILL	-5L			/* keyboard "process killed" key (usu. ^C) */
#define MAGIC		0125252		/* unusual value for top of stack	*/
#define	SAFETY		16

/* initialization constants */

#define	INITARGC	1		/* initial process argc		*/
#define	INITSTK		0x1000	/* initial process stack    */
#define	INITPRIO	20		/* initial process priority	*/
#define	INITNAME	"xmain"	/* initial process name		*/
#define	INITRET		userret	/* processes return address	*/
#define	INITREG		0		/* initial register contents	*/
#define	QUANTUM		20		/* clock ticks until preemption (was 1)	*/
#define	INITARGS	1,0		/* initial count/arguments	*/
#define	NSAVEREGS	3		// no. of registers pushed by ctxsw

/* misc. utility functions */

#define	disable(x)	(x)=sys_disabl()/* save interrupt status	*/
#define	restore(x)	sys_restor(x)	/* restore interrupt status	*/
#define	enable()	sys_enabl()	/* enable interrupts		*/
#define	pause()		sys_wait()	/* machine "wait for interr."	*/
#define	halt()		sys_xdone()	/* halt PC-Xinu			*/
#define	xdisable(x)	(x)=sys_xdisabl() /* save int & dosflag status	*/
#define	xrestore(x)	sys_xrestor(x)	/* restore int & dosflag status	*/

#define	isodd(x)	(01&(int)(x))
#define	min(a,b)	(((a) < (b)) ? (a) : (b))
#define	max(a,b)	(((a) > (b)) ? (a) : (b))


/* platform-specific functions and variables */

extern int sys_disabl(void);	// return flags & disable ints
extern void sys_restor(int);	// restore the flag register
extern void sys_enabl(void);	// enable interrupts
extern void sys_wait(void);		// wait for an interrupt
extern void sys_xdone(void);	// terminate Xinu
extern int sys_xdisabl(void);	// Return interrupts to MS-DOS
extern void sys_xrestor(int);	// Interrupts back to Xinu


/* process management variables */

extern int rdyhead, rdytail;	// ready process queue
extern int preempt;				// scheduler's preemption counter

extern int run;

extern void (* usrpanic)();
extern void nullfun(void);
extern int exc_isr();			/* exception handler		*/

extern int resched(void);
//extern int kprintf(const char *, ...);
extern int mapinit(int, isr_t, int);
extern int maprestore(void);
extern void clkinit(void);
extern int ready(int);
extern int panic(const char *);

//SYSCALL create(intfunptr, size_t, short, char *namep, int, ...);
SYSCALL resume(int);
//SYSCALL open(int, char *, ...);
SYSCALL getpid(void);
SYSCALL close(int);
SYSCALL die(int);
SYSCALL xdone(void);
SYSCALL gettime(long *);
SYSCALL sleep(int);
SYSCALL unsleep(int);
char * getmem(size_t);

extern long receive();
extern long recvclr();
extern long recvtim();
extern send(int, long);
extern sendf(int, long);
extern sendn(int, long);
//extern int sprintf(const char *, ...);
//extern int printf(const char *, ...);
