/* io.h -  fgetc, fputc, getchar, isbaddev, putchar */

#define INTVECI inint		/* input interrupt dispatch routine	*/
#define INTVECO outint		/* output interrupt dispatch routine	*/
extern int INTVECI();
extern int INTVECO();

#define NMAPS	0x20	/* number of intmap entries		*/

struct	intmap_t {		/* device-to-interrupt routine mapping	*/
	char	ivec;		/* interrupt number			*/
	char	callinst;	/* the call instruction			*/
	WORD	intcom;		/* common interrupt code		*/
	isr_t	oldisr;		/* old int. service routine */
	isr_t 	newisr;		/* pointer to the new int. ser. routine */
	WORD	mdevno;		/* minor device number			*/
	WORD	biosflag;	/* if nonzero, call the old isr		*/
};

/*
 * NOTE: The intmap structure takes a total of 8 words or 16 bytes
 * per record.
 *
 * The intmap table is defineed in intmap.asm, and pointed to by
 * far pointer _intmap (defined in intmap.asm).
 */
extern int nmaps;				// number of active intmap entries

#define BADDEV		(-1)

#define isbaddev(f) ( (f)<0 || (f)>=NDEVS )
#define fopen(n,m) open(STDIO, (n), (m))
#define fclose(d) close(d)

/* In-line I/O procedures */

#define getchar()		getc(STDIN)
#define putchar(ch)		putc(STDOUT,(ch))
#define fgetc(unit)		getc((unit))
#define fputc(ch,unit)	putc((unit),(ch))

extern int _doprnt();	/* output formatter */
extern int init(int,int);

#define INIT 1
#define UNINIT 0
