;---------------------------------------------------------------------
; dos.asm
; macros for uniform data/code segment declarations (independent of
; memory model), and to permit access from Borland C code.
;
; far memory model assumed here
; DISCUTERE I CASI PER:
; - accesso glob C da asm e C
; - accesso glob asm da asm e C
; se possibile adattare a tutti imodelli senza edit di questo file

;---------------------------------------------------------------------
; segments must be public, so psegs from separate modules get
; stitched together into a unique memory segment, called ASMTEXT;
;
; thus all code within any pseg runs with CS set to ASMTEXT, so
; pcxflag (see xeidi.asm) is accessed as CS:pcxflag from any pseg
;
; class 'CODE' places all psegs contiguous to compiled C code (but
; addresses (offsets) are relative to ASMTEXT)

pseg	macro
ASMTEXT	segment	word public 'CODE'
	assume	cs:ASMTEXT
	endm

endps	macro
ASMTEXT	ends
	endm


;---------------------------------------------------------------------
; segments _DATA declared by dseg are public, so all of them get
; stitched together into a unique segment _DATA

; dseg for any model except huge: _DATA will join other segments
; from C code to form the segment group DGROUP; in practice, DGROUP
; resides in a single memory segment, and DS will be set to point to it
; by code that references data (C globals or data declared in dseg's)

;dseg	macro
;DGROUP	group	_DATA
;_DATA	segment	word public 'DATA'
;	endm

; dseg for huge model: DGROUP/assume unneeded, class 'FAR_DATA' makes dsegs
; contiguous to compiled C globals (addresses (offsets) relative to _DATA)

dseg	macro
_DATA	segment	word public 'FAR_DATA'
	endm

endds	macro
_DATA	ends
	endm


;-----------------------------------------------------------------------------------
; ret defined as retf/ret, depending on the memory model

RET	macro
retf
	endm
