/* xmalloc.c -- xmalloc */

#include <kernel.h>
#include <conf.h>
#include <proc.h>
#include <dos.h>
#include <mem.h>

/*---------------------------------------------------------------------------
 * xmalloc -- allocate memory using a malloc-like technique
 *---------------------------------------------------------------------------
 */
char * xmalloc(nbytes)
WORD nbytes;
{
	char	*mp;
	XBLOCK	*xmp;
	int	ps;

	if (nbytes == 0) 
		panic("xmalloc: 0 bytes requested\n");
/*        return(NULL); */
	nbytes += sizeof(XBLOCK);
	nbytes = roundp(nbytes);
	disable(ps);
	if ((mp=getmem(nbytes)) == NULL) {
		kprintf("xmalloc: out of memory, %d bytes requested\n",nbytes);
		panic("xmalloc: memory depleted\n");
		restore(ps);
		return(NULL);
	}
	xmp = (XBLOCK *)mp;
	xbinsert(xmp, nbytes>>4, currpid);
	restore(ps);
	return ((char *)(xmp+1));
}
