/* x_pmem.c  -  x_pmem */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <mem.h>
#include <dos.h>

/*------------------------------------------------------------------------
 *  x_pmem  --  (command pmem) print process's memory statistics
 *------------------------------------------------------------------------
 */
COMMAND  x_pmem(nargs,args)
int  nargs;
char *args[];
{
    struct pentry    *pptr;
	para		xm, xb, xf;
	XBLOCK		*xbp, *xfp;
    int n, total, ps, pid;

    if ( nargs != 2 ) {
        fprintf(STDERR,"Usage: pmem pid\n");
		return(SYSERR);
	}
    pid = atoi(args[1]);
    if (isbadpid(pid) || (pptr= &proctab[pid])->pstate==PRFREE) {
        return SYSERR;
	}
	pptr = &proctab[pid];
    xb = pptr->pmlist;
    if (xb == 0) {
        printf("pmem: missing stack block [%d]",pid);
        return SYSERR;
    }
    xbp = (XBLOCK *)BLK2ADDR(xb);
    n = total = 0;
    while (TRUE) {
        xf = xbp->xbfore;
        if (xf == 0) {
            printf("pmem: invalid memory list [%d]",pid);
            return SYSERR;
        }
        n += 1;
        total += xbp->xblen*16;
        printf("%4x %6d\n", xbp->xbfore, xbp->xblen*16);
        if (xbp->xbfore == xb) break;
        xbp = (XBLOCK *)BLK2ADDR(xf);
    }    
    printf("blocks: %d total: %d\n", n, total);
	return(OK);
}
