/* xblock.c - xbinsert, xbdelete */

#include <conf.h>
#include <kernel.h>
#include <dos.h>
#include <proc.h>
#include <mem.h>

/*------------------------------------------------------------------------
 *  xbinsert  --  insert an XBLOCK into the current process memory list
 *------------------------------------------------------------------------
 */
xbinsert(xmp, npara, pid)
XBLOCK *xmp;
WORD npara;
int	pid;
{
	struct pentry *pptr;
	para xm, xb, xf;
	XBLOCK *xbp, *xfp;

    xm = seg(xmp);
	pptr = &proctab[pid];
    xb = pptr->pmlist;
	if (xb == 0)
		panic("xbinsert: missing stack block");
	xbp = (XBLOCK *)BLK2ADDR(xb);
	xf = xbp->xbfore;
	if (xf == 0)
		panic("xbinsert: invalid memory list");
	xfp = (XBLOCK *)BLK2ADDR(xf);
	xmp->xbback = xb;
	xmp->xbfore = xf;
	xmp->xblen = npara;
	xbp->xbfore = xm;
	xfp->xbback = xm;
	pptr->pmalloc += npara;
}

/*------------------------------------------------------------------------
 *  xbdelete  --  delete an XBLOCK from the current process memory list
 *------------------------------------------------------------------------
 */
WORD xbdelete(xmp, pid)
XBLOCK	*xmp;
int	pid;
{
	struct pentry *pptr;
	para xf, xm, xb, sb;
	XBLOCK *xfp, *xbp;
	WORD npara;

	xm = seg(xmp);
	pptr = &proctab[pid];
	sb = pptr->pmlist;
	if (sb == 0)
		panic("xbdelete: missing stack block");
	if (sb == xm)
		panic("xbdelete: cannot delete stack block");
	npara = xmp->xblen;
	pptr->pmalloc -= npara;
	xb = xmp->xbback;
	if ( xb == 0 )
		panic("xbdelete: empty back pointer");
	xbp = (XBLOCK *)BLK2ADDR(xb);
	if ( xbp->xbfore != xm )
		panic("xbdelete: inconsistent back pointer");
	xf = xmp->xbfore;
	if (xf == 0)
		panic("xbdelete: empty fore pointer");
	xfp = (XBLOCK *)BLK2ADDR(xf);
	if (xfp->xbback != xm)
		panic("xbdelete: inconsistent fore pointer");
	xfp->xbback = xb;
	xbp->xbfore = xf;
	return(npara);
}
