/* ex9.c - Try a stack overflow */

#include <conf.h>
#include <kernel.h>
#include <proc.h>

void psnap1(int);
void pprint(Bool, int);
int printf(const char *, ...);
int kprintf(const char *, ...);
int xdone(void);
int sys_disabl(void);
void sys_restor(int);
int getpid(void);

int me;
unsigned int mysp, myss;
int kgetc(int);


void f(unsigned long int);

#define N 0x00f0

void f(unsigned long int n)
{
	char dummy[N];
	int i;

	for (i = 0; i < N; i++)
		dummy[i] = i;

	if (n > 0L) {
		mysp = _SP;
		myss = _SS;
		if (n % 50 == 0) {
			kprintf("%10ld -> ", n);
			kprintf("%04x:%04x \n", myss, mysp); 
		}
		if ( n % 100 == 0 ) {
			kprintf("%c", 7);
			resched();
		}
		f(n-1);
	}
	else 
		kprintf("finished\n");
}

int spy()
{
	kprintf("resched done%c", 7);
	return(0);
}

void xmain(void)
{
	int flags;
	struct pentry  *selfptr;
	
	me = getpid();
	selfptr = proctab + me;
	disable(flags);
	selfptr->phastrap = 1;
	selfptr->ptfn = &spy;
	f(1000000L);
	restore(flags);
	xdone();
}
