/* mem.c  -  mem */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <dos.h>

#define STATUS getdev("status")

/*------------------------------------------------------------------------
 *  mem  --  check memory 
 *------------------------------------------------------------------------
 */
LSYSCALL mem()
{
	char	*pp;
	para	p;
	word 	total,lp;
	unsigned long	ltotal, h, minh, maxh, avgh;
	word	nholes;
	int	ps;

	disable(ps);
	total = 0;
	nholes = 0;
	minh = maxh = 0L;
	p = memlist.mnext;
	while ( p != 0 ) {
		nholes++;
		pp = memp(p);
		lp = memlen(pp);
		h = ((unsigned long)lp)<<4;
		if ( maxh < h )
			maxh = h;
		if ( minh > h || minh == 0L )
			minh = h;
		total += lp;
		p = memnext(pp);
	}
	restore(ps);
	if ( total != memlist.mlen )
        fprintf(STATUS,"\n ** inconsistent memory allocation **");
	ltotal = ((unsigned long)total)<<4;
    return(ltotal);
}
