/* x_memsta.c  -  x_memstat */

#include <conf.h>
#include <kernel.h>
#include <mem.h>
#include <dos.h>

/*------------------------------------------------------------------------
 *  x_memstat  --  (command memstat) print memory statistics
 *------------------------------------------------------------------------
 */
COMMAND  x_memstat(nargs,args)
int  nargs;
char *args[];
{
	char	*pp;
	para	p;
	word 	total,lp;
	unsigned long	ltotal, h, minh, maxh, avgh;
	word	nholes;
	int	ps;

	if ( nargs > 1 ) {
		fprintf(STDERR,"Usage: memstat\n");
		return(SYSERR);
	}
	disable(ps);
	total = 0;
	nholes = 0;
	minh = maxh = 0L;
	p = memlist.mnext;
	while ( p != 0 ) {
		nholes++;
		pp = memp(p);
		lp = memlen(pp);
		h = ((unsigned long)lp)<<4;
		if ( maxh < h )
			maxh = h;
		if ( minh > h || minh == 0L )
			minh = h;
		total += lp;
		p = memnext(pp);
	}
	restore(ps);
	if ( total != memlist.mlen )
		printf("*inconsistent memory allocation*\n");
	ltotal = ((unsigned long)total)<<4;
	printf("%9lu total memory\n",ltotal);
	if ( nholes > 0 ) {
		printf("%9u hole%s\n",nholes,(nholes==1)?"":"s");
		if ( nholes > 1 ) {
			avgh = ltotal/nholes;
			printf("%9lu min hole size\n",minh);
			printf("%9lu max hole size\n",maxh);
			printf("%9lu avg hole size\n",avgh);
		}
	}
	return(OK);
}
