/* x_cat.c - x_cat */

#include <conf.h>
#include <kernel.h>
#include <io.h>

#define BUFSIZ	512

/*------------------------------------------------------------------------
 *  x_cat  -  (command cat) concatenate files and write on stdout
 *------------------------------------------------------------------------
 */
COMMAND	x_cat(nargs, args)
int nargs;
char *args[];
{
    int i, len;
	int	dev;
	char	*buf;

	args++;
	nargs--;
	if ( (buf=getmem(BUFSIZ)) == NULL ) {
		fprintf(STDERR,"cat: no memory\n");
		freemem(buf,BUFSIZ);
		return(SYSERR);
	}
	if ( nargs == 0 ) {
        while ( (len=read(STDIN,buf,BUFSIZ)) > 0 )
			write(STDOUT,buf,len);
		freemem(buf,BUFSIZ);
		return(OK);
	}
	while ( nargs > 0 ) {
        dev = fopen(*args, "ro");
		if ( isbaddev(dev) ) {
			fprintf(STDERR, "cat: cannot open %s\n",*args);
			freemem(buf,BUFSIZ);
			return(SYSERR);
		}
		while ( (len=read(dev,buf,BUFSIZ)) > 0) {
            for (i=0 ; i<=len ; i++)
            buf[i]=buf[i] & 0x7f;
            write(STDOUT,buf,len);
		}
		close(dev);
		args++;
		nargs--;
	}
	freemem(buf,BUFSIZ);
	return(OK);
}
