/* x_butler.c  -  x_butler */

// Does not appear to work correctly without windows
// but it doesn't for the original XINU 7.9 either!

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <dos.h>
#include <q.h>

static char *sttab[8] = {
	"???",
	"current",
	"free",
	"ready",
	"receiving",
	"sleeping ",
	"suspended",
	"waiting"
};


static struct psnap {
	int	state;
	int	prio;
	char	name[10];
	char	*pbase;
	int	plen;
	char	*pregs;
} stab[NPROC];

static int pmark[NPROC];
static char qname[4];


#define CTRLC		3			/* ASCII code for control-C*/
#define STATE(s)	sttab[((s)>0&&(s)<8)?(s):0]
#define next(i)		q[(i)].qnext
#define prev(i) 	q[(i)].qprev
#define key(i)		q[(i)].qkey


/*------------------------------------------------------------------------
 *  x_butler  --  (command butler) print process information
 *------------------------------------------------------------------------
 */
COMMAND  x_butler(nargs,args)
int  nargs;
char *args[];
{
	int	i,j,s;

	if ( nargs > 1 ) {
		fprintf(STDERR,"Usage: butler\n");
		return(SYSERR);
	}
	pprint();
	printf("Press any key to continue . . .");
	if ( kgetc(0) == CTRLC )
		return(OK);
	printf("\n");
	for ( i=0; i<NPROC; i++ )
		pmark[i] = 0;
	/* print the semaphore queues */
	i = NPROC;
	for ( j=0; j<NSEM; j++ ) {
		qname[0] = 'S';
		qname[1] = '0'+(j/10);
		qname[2] = '0'+(j%10);
		qname[3] = 0;
		qprint(i,qname,PRWAIT,0);
		i += 2;
	}
	qprint(i,"RDY",PRREADY,1);
	i += 2;
	qprint(i,"SLP",PRSLEEP,1);
	for ( i=0 ; i<NPROC; i++ )
		if ( pmark[i] == 0 ) {
			s = stab[i].state;
			if ( s == PRWAIT || s == PRREADY || s == PRSLEEP )
				printf("?%02d: %s %s\n",i,
				    stab[i].name,STATE(s));
		}
}


LOCAL  pprint()
{
	int	i,j;
	int	s;
	int	*addr;
	struct	pentry *pptr;
	struct	psnap *sptr;

	printf("\n id state      prio name        sp   ss  top");
	printf("   di   si flag   bp\n");
	for ( i=0; i<NPROC; i++ ) {
		pptr = &proctab[i];
		sptr = &stab[i];
		sptr->state = pptr->pstate;
		sptr->prio = pptr->pprio;
		strcpy(sptr->name,pptr->pname);
		sptr->pbase = pptr->pbase;
		sptr->plen = pptr->plen;
		sptr->pregs = pptr->pregs;
	}
	for ( i=0; i<NPROC; i++ ) {
		sptr = &stab[i];	/* pointer to process entry	*/
		if ( (s=sptr->state) != PRFREE ) {
			printf("%3d %-9s %5d %s",
				i,STATE(s),
				sptr->prio,sptr->name);
			printf(" %04x %04x %04x",FP_OFF(sptr->pregs),
				FP_SEG(sptr->pregs),sptr->plen);
			if ( s != PRCURR ) {
				addr = (int *) sptr->pregs;
				for (j=0; j<4; j++ )
					printf(" %04x",*addr++);
			}
			printf("\n");
		}
	}
}


LOCAL qprint(i,qnam,state,keyprint)
int i;
char *qnam;
int state;
int keyprint;
{
	int	ni,pi,s;

	if ( prev(i) != EMPTY )
		printf("%s: nonempty qprev header\n",qnam);
	if ( next(i+1) != EMPTY )
		printf("%s: nonempty qnext header\n",qnam);
	for ( ni=next(i), pi=i ; ni < NPROC ; pi=ni, ni=next(ni) ) {
		printf("%s: pid=%02d",qnam,ni);
		if ( ni < 0 ) {
			printf(" ?queue index corrupted!\n");
			break;
		}
		printf(" %s",stab[ni].name);
		if ( keyprint )
			printf(" key=%d",key(ni));
		if ( pmark[ni]++ != 0 ) {
			printf(" ?process on another queue!\n");
			break;
		}
		s = stab[ni].state;
		if ( s != state )
			printf(" ?illegal state (%d=%s)",s,STATE(s));
		if ( prev(ni) != pi )
			printf(" ?invalid qprev index (%d)",prev(ni));
		printf("\n");
	}
	if ( prev(ni) != pi ) {
		printf("%s: ?invalid qprev index (%d)",qnam,prev(ni));
	}
	if ( ni != i+1 )
		printf("%s: ?queue terminates incorrectly (%d)",qnam,ni);
	if ( pi != i )
		printf("----\n");
	return(OK);
}
