/* pipputc.c - pipputc */

#include <conf.h>
#include <kernel.h>
#include <pipe.h>

/*-------------------------------------------------------------------
 *  pipputc  --  write one character to a pipe device
 *-------------------------------------------------------------------
 */
pipputc(devptr, ch)
struct  devsw   *devptr;
        char    ch;
{
    struct  pipe    *pptr;
    int     ps;

    disable(ps);
    pptr = &pipe[devptr->dvminor];
    if (pptr->pstate == PCLOSED) {
        restore(ps);
        return SYSERR;
    }
    pptr->wpid = getpid();
    wait(pptr->ssem);               /* wait for space in buff */
    pptr->data = ch;                /* put the character       */
    signal(pptr->asem);
    restore(ps);
    return(OK);
}
