/* pipgetc.c - pipgetc */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <pipe.h>

/*-------------------------------------------------------------------
 *  pipgetc  --  read one character from a pipe device
 *-------------------------------------------------------------------
 */
pipgetc(devptr)
struct  devsw   *devptr;
{
    struct  pipe    *pptr;
    int     ps;
    char    ch;

    disable(ps);
    pptr = &pipe[devptr->dvminor];
    pptr->rpid = getpid();
    wait(pptr->asem);                    /* wait for data */
    if ((pptr->wpid == BADPID) && (scount(pptr->asem) == 0)) {
        restore(ps);
        return EOF;
    }
    ch = pptr->data;                    /* get the character       */
    signal(pptr->ssem);                 /* signal space available */
    restore(ps);
    return(ch);
}
